<div class="mb-2">
    <label class="form-label">{{ __('user::role.name') }}</label>
    <div class="form-check">
        <h5>
            <input class="form-check-input" id="all_roles" type="checkbox" value="all" onclick="set_all(this, 'permission');" @if ($super) checked disabled @endif>
            <label class="form-check-label" for="all_roles">{{ __('role.all') }}</label>
        </h5>
    </div>
</div>
@if (!empty($permissions))
    <div class="accordion custom-accordion" id="permission">
        @php
            $count = count($permissions);
            $index = 0;
        @endphp
        @foreach ($permissions as $k_p => $p)
            <div class="card-body py-0" id="level-1-{{ $k_p }}">
                <h5 class="flex-grow-1 position-relative">
                    <input class="form-check-input" id="{{ $k_p }}" type="checkbox" value="all" onclick="set_all(this, 'level-1-{{ $k_p }}')" @if ($super) checked disabled @endif>
                    <label class="form-check-label" for="{{ $k_p }}">{{ $p['name'] ?? '' }}</label>
                </h5>
                <div class="row">
                    @if (!empty($p['sub_menu']))
                        @php
                            $l = array_key_last($p['sub_menu']);
                        @endphp
                        @foreach ($p['sub_menu'] as $k_sp => $sp)
                            @php
                                $pid = "{$k_p}_{$k_sp}";
                            @endphp
                            @if (!empty($sp['sub_menu']))
                                <x-permission.collapsed class="{{ $k_sp != $l ? 'mb-2' : '' }}" pid="{{ $pid }}" header="{{ $sp['name'] ?? '' }}" :subMenu="$sp['sub_menu']" level="2" />
                            @else
                                <div class="{{ $k_sp != $l ? 'mb-2' : '' }}">
                                <x-permission.choice class="px-0" pid="{{ $pid }}" header="{{ $sp['name'] ?? '' }}" :permission="$sp['permission'] ?? [] " level="2" :super="$super" :oilpriceAbcChecked="$oilprice_abc_checked" />
                                </div>
                            @endif
                        @endforeach
                    @else
                        <x-permission.choice pid="{{ $k_p }}_{{ $k_p }}" header="{{ $p['name'] ?? '' }}" :permission="$p['permission']" level="2" :super="$super" :oilpriceAbcChecked="$oilprice_abc_checked" />
                    @endif
                </div>
            </div>
            @if (++$index != $count)
                <hr>
            @endif
        @endforeach
    </div>
@endif
