@extends('form.app')

@section('styles')
@endsection

@section('content')
    {{-- navbar --}}
    @includeIf('user::user.form.navbar')
    <form class="row" id="user_frm" method="POST" onsubmit="setSave(); return false;" enctype="multipart/form-data">
        @csrf
        <input id="id" name="id" type="hidden" value="{{ $data->id ?? '0' }}">
        <div class="col-md-9">
            <div class="card card-body">
                {{-- image --}}
                @includeIf('user::user.form.image')
                {{-- profile --}}
                @includeIf('user::user.form.profile')
                {{-- password --}}
                @includeIf('user::user.form.password')
            </div>
        </div>
        <div class="col-md-3">
            {{-- role --}}
            @includeIf('user::user.form.role')
            {{-- status --}}
            @includeIf('user::user.form.status')
        </div>
    </form>
@endsection

@section('scripts')
    <script>
        var $_config = $.parseJSON('<?= json_encode($config) ?>');
    </script>
    {{ module_vite('build-user', 'resources/assets/js/user.js') }}
@endsection
