<?php

use Illuminate\Support\Facades\Route;
use Maatwebsite\Excel\Row;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::prefix('admin')->group(function () {
	// Login page
	Route::get('/',  'LoginController@index')->name('admin.login');
	// Login
	Route::post('/set_login', 'LoginController@set_login')->name('admin.set_login');
	// logout
	Route::get('/logout', 'LoginController@logout')->name('admin.logout');
});
Route::group(['prefix' => 'admin', 'middleware' => ['auth:admin', 'adminAccessControl']], function () {
	Route::prefix('user')->group(function () {
		Route::prefix('list')->group(function () {
			Route::get('/', 'UserAdminController@index')->name('admin.user.user.index');
			Route::get('/datatable_ajax', 'UserAdminController@datatable_ajax')->name('admin.user.user.datatable_ajax');

			Route::get('/add', 'UserAdminController@form')->name('admin.user.user.add');
			Route::get('/edit/{id}', 'UserAdminController@form')->name('admin.user.user.edit');
			Route::get('/view/{id}', 'UserAdminController@form')->name('admin.user.user.view');
			Route::post('/save', 'UserAdminController@save')->name('admin.user.user.save');

			Route::post('/set_status', 'UserAdminController@set_status')->name('admin.user.user.set_status');
			Route::post('/set_delete', 'UserAdminController@set_delete')->name('admin.user.user.set_delete');
		});

		// ============================== role ============================== //
		Route::prefix('role')->group(function () {
			Route::get('/', 'RoleAdminController@index')->name('admin.user.role.index');
			Route::get('/datatable_ajax', 'RoleAdminController@datatable_ajax')->name('admin.user.role.datatable_ajax');

			Route::get('/add', 'RoleAdminController@form')->name('admin.user.role.add');
			Route::get('/edit/{id}', 'RoleAdminController@form')->name('admin.user.role.edit');
			Route::get('/view/{id}', 'RoleAdminController@form')->name('admin.user.role.view');
			Route::post('/save', 'RoleAdminController@save')->name('admin.user.role.save');

			Route::post('/set_sort', 'RoleAdminController@set_sort')->name('admin.user.role.set_sort');
			Route::post('/set_status', 'RoleAdminController@set_status')->name('admin.user.role.set_status');
			Route::post('/set_delete', 'RoleAdminController@set_delete')->name('admin.user.role.set_delete');

			Route::post('/get_list', 'RoleAdminController@get_list')->name('admin.user.role.get_list');
		});

		// ============================== activites ============================== //
		Route::prefix('activities')->group(function () {
			Route::get('/', 'ActivitiesAdminController@index')->name('admin.user.activities.index');
			Route::get('/datatable_ajax', 'ActivitiesAdminController@datatable_ajax')->name('admin.user.activities.datatable_ajax');
			Route::get('/view/{id}', 'ActivitiesAdminController@form')->name('admin.user.activities.view');
			Route::post('/get_user_list', 'ActivitiesAdminController@get_user_list')->name('admin.user.activities.get_user_list');
		});
	});
});
