import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';

export default defineConfig({
	build: {
		outDir: '../../public/build-user',
		emptyOutDir: true,
		manifest: true,
	},
	plugins: [
		laravel({
			publicDirectory: '../../public',
			buildDirectory: 'build-user',
			input: [
				__dirname + '/resources/assets/sass/app.scss',
				__dirname + '/resources/assets/js/activities.js',
				__dirname + '/resources/assets/js/role.js',
				__dirname + '/resources/assets/js/login.js',
				__dirname + '/resources/assets/js/user.js'
			],
			refresh: true,
		}),
	],
});


//export const paths = [
//    'Modules/$STUDLY_NAME$/resources/assets/sass/app.scss',
//    'Modules/$STUDLY_NAME$/resources/assets/js/app.js',
//];