<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use Illuminate\Support\Facades\Log;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     */
    protected function schedule(Schedule $schedule): void
    {
        // $schedule->command('inspire')->hourly();
        
        // ลบข้อมูลการเดินทาง (check_in_out) ที่เก่ากว่า 3 เดือน - ทำงานทุกวันเวลา 02:00 น.
        $schedule->command('checkinout:cleanup --months=3')
                 ->daily()
                 ->at('02:00')
                 ->withoutOverlapping()
                 ->onSuccess(function () {
                     Log::info('Scheduled cleanup check_in_out data completed successfully');
                 })
                 ->onFailure(function () {
                     Log::error('Scheduled cleanup check_in_out data failed');
                 });
    }

    /**
     * Register the commands for the application.
     */
    protected function commands(): void
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}

