<?php

namespace App\Exceptions;

use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Throwable;

class Handler extends ExceptionHandler
{
    /**
     * The list of the inputs that are never flashed to the session on validation exceptions.
     *
     * @var array<int, string>
     */
    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    /**
     * Register the exception handling callbacks for the application.
     */
    public function register(): void
    {
        $this->reportable(function (Throwable $e) {
            //
        });
    }
    public function render($request, Throwable $exception)
    {
        if ($this->isHttpException($exception) && env('APP_DEBUG') == false) {
            switch ($exception->getStatusCode()) {
                case 403:
                    return redirect(mwz_route('error.page', 403));
                    break;
                case 404:
                    return redirect(mwz_route('error.page', 404));
                    break;
                case 500:
                    return redirect(mwz_route('error.page', 500));
                    break;
            }
        }
        return parent::render($request, $exception);
    }
}
