<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class ActivityExport implements FromCollection, WithHeadings, WithMapping, ShouldAutoSize, WithColumnFormatting
{
	public $collection;

	public function __construct($collection)
	{
		$this->collection = $collection;
	}

	public function headings(): array
	{
		$header = [
			'name',
			'surname',
			'company_name',
			'tel',
			'email',
			'activities',
			'status',
			'note',
			'created',
			'updated'
		];
		$headings = [];

		foreach ($header as $value)
			$headings[] = __('field.' . $value);

		return $headings;
	}

	public function collection()
	{
		return $this->collection;
	}

	public function map($data): array
	{
		return [
			$data->name ?? '',
			$data->surname ?? '',
			$data->company_name ?? '',
			$data->tel ?? '',
			$data->email ?? '',
			implode(', ', $data->activities->pluck('local.name')->toArray() ?? []),
			$data->status ?? '',
			$data->note ?? '',
			$data->created_at ?? '',
			$data->updated_at ?? '',
		];
	}

	public function columnFormats(): array
	{
		return [
			'I' => NumberFormat::FORMAT_DATE_DDMMYYYY,
			'J' => NumberFormat::FORMAT_DATE_DDMMYYYY,
		];
	}
}
