<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class ConferenceExport implements FromCollection, WithHeadings, WithMapping, ShouldAutoSize, WithColumnFormatting
{
	public $collection;

	public function __construct($collection)
	{
		$this->collection = $collection;
	}

	public function headings(): array
	{
		$header = [
			'name',
			'type',
			'start',
			'end',
			'updated',
		];
		$headings = [];

		foreach ($header as $value)
			$headings[] = __('field.' . $value);

		return $headings;
	}

	public function collection()
	{
		return $this->collection;
	}

	public function map($data): array
	{
		return [
			$data->local->name ?? '',
			__('field.' . strtolower($data->type)),
			$data->start_at,
			$data->end_at,
			$data->updated_at ?? '',
		];
	}

	public function columnFormats(): array
	{
		return [
			'C' => NumberFormat::FORMAT_DATE_DDMMYYYY,
			'D' => NumberFormat::FORMAT_DATE_DDMMYYYY,
		];
	}
}
