<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class ConferenceMemberExport implements FromCollection, WithHeadings, WithMapping, ShouldAutoSize, WithColumnFormatting
{
	public $collection;

	public function __construct($collection)
	{
		$this->collection = $collection;
	}

	public function headings(): array
	{
		$header = [
			'name',
			'status_certificate',
			'status',
			'updated'
		];
		$headings = [];

		foreach ($header as $value)
			$headings[] = __('field.' . $value);

		return $headings;
	}

	public function collection()
	{
		return $this->collection;
	}

	public function map($data): array
	{
		$member = [];
		if (!empty($data->member_detail))
			$member = json_decode($data->member_detail, true);

		return [
			!empty($member['name']) ? $member['name'] : $data->member->name ?? '',
			__('field.' . strtolower($data->certificate)),
			__('field.' . strtolower($data->status)),
			$data->updated_at ?? '',
		];
	}

	public function columnFormats(): array
	{
		return [
			'D' => NumberFormat::FORMAT_DATE_DDMMYYYY,
		];
	}
}
