<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use PhpOffice\PhpSpreadsheet\Shared\Date;


class ContactExport implements FromCollection, WithHeadings, WithMapping, ShouldAutoSize, WithColumnFormatting
{
	public $collection;

	public function __construct($collection)
	{
		$this->collection = $collection;
	}
	public function headings(): array
	{
		return [
			'ชื่อ-นามสกุล',
			'เบอร์โทร',
			'อีเมล',
			'เรื่อง',
			'ข้อความ',
			'วันที่ส่ง',
		];
	}
	public function collection()
	{
		return $this->collection;
	}

	public function map($data): array
	{
		return [
			$data->name ?? '',
			str_format($data->tel ?? ''),
			$data->email ?? '',
			$data->subject_opt->local->name ?? '',
			$data->msg ?? '',
			Date::PHPToExcel($data->created_at),
		];
	}

	public function columnFormats(): array
	{
		return [
			'F' => NumberFormat::FORMAT_DATE_DDMMYYYY,
		];
	}
}
