<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class MemberHistoryExport implements FromCollection, WithHeadings, WithMapping, ShouldAutoSize
{
	public $collection;

	public function __construct($collection)
	{
		$this->collection = $collection;
	}

	public function headings(): array
	{
		$header = [
			'type',
			'status',
			'updated',
		];
		$headings = [];

		foreach ($header as $value)
			$headings[] = __('field.' . $value);

		return $headings;
	}

	public function collection()
	{
		return $this->collection;
	}

	public function map($data): array
	{
		return [
			__('field.' . strtolower($data->type)),
			__('field.' . strtolower($data->is_accept)),
			$data->updated_at,
		];
	}
}
