<?php

namespace App\Exports;

use Modules\OilPrice\app\Models\OilPrice;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class OilPriceExport implements FromCollection, WithHeadings, WithMapping, WithStyles
{
    protected $search;
    protected $scheme_type;

    public function __construct($search = null, $scheme_type = null)
    {
        $this->search = $search;
        $this->scheme_type = $scheme_type;
    }

    public function collection()
    {
        $query = OilPrice::query()->where('status', true);

        if ($this->scheme_type) {
            $query->where('scheme_type', $this->scheme_type);
        }

        if ($this->search) {
            $query->where(function($q) {
                $q->where('gap_range', 'like', "%{$this->search}%")
                  ->orWhere('scheme_type', 'like', "%{$this->search}%")
                  ->orWhere('reference', 'like', "%{$this->search}%");
            });
        }

        return $query->orderBy('gap_min', 'ASC')->get();
    }

    public function headings(): array
    {
        return [
            'ID',
            'ประเภทโครงการ',
            'Gap ราคาน้ำมัน',
            'ขั้นต่ำ',
            'สูงสุด',
            'ราคาน้ำมัน (Reference)',
            'ช่วงขั้นต่ำ',
            'ช่วงสูงสุด',
            'ค่า A',
            'ค่า B',
            'ค่า C',
            'อัตรา (Rate)',
            'ค่า GAP',
            'A (Km/L)',
            'B (ตัวคูณ)',
            'C (THB/Km)',
            'เชื่อ (Credit)',
            'หน่วยเงิน',
            'หมายเหตุ',
            'สถานะ',
            'วันที่สร้าง',
            'วันที่อัพเดท',
        ];
    }

    public function map($oilprice): array
    {
        return [
            $oilprice->id,
            ucfirst($oilprice->scheme_type),
            $oilprice->gap_range,
            $oilprice->gap_min,
            $oilprice->gap_max,
            $oilprice->reference,
            $oilprice->range_min,
            $oilprice->range_max,
            $oilprice->value_a,
            $oilprice->value_b,
            $oilprice->value_c,
            $oilprice->rate,
            $oilprice->gap_value,
            $oilprice->km_l,
            $oilprice->multiplier,
            $oilprice->rate_per_km,
            $oilprice->credit,
            $oilprice->currency,
            $oilprice->remark,
            $oilprice->status ? 'Active' : 'Inactive',
            $oilprice->created_at->format('d/m/Y H:i'),
            $oilprice->updated_at->format('d/m/Y H:i'),
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true]],
        ];
    }
}
