<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Modules\User\app\Http\Controllers\ActivitiesController;
use Modules\User\app\Http\Controllers\RoleController;
use Symfony\Component\HttpFoundation\Response;

class AdminAccessControl
{
	/**
	 * Handle an incoming request.
	 *
	 * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
	 */
	public function handle(Request $request, Closure $next): Response
	{
		if (config('app.admin_access_control')) {
			// check status
			if (Auth::check() && Auth::user()->id != 1 && (Auth::user()->status == 0 || empty(Auth::user()->role->status) || count(Auth::user()->role->permissions) == 0))
				return redirect()->route('admin.logout');

			$role = new RoleController();
			$route_name = Route::currentRouteName();

			if ($role->allow_route() || in_array($route_name, ['admin.homepage', 'admin.mwz.slug.get_list', 'admin.user.role.get_list', 'admin.user.user.edit']) || ($route_name == 'admin.user.user.save' && Auth::user()->id == $request->get('id'))) {
				// keep activities log
				// if (str_contains($route_name, 'admin.member.list'))
				// 	ActivitiesController::keep($request, $route_name);
				return $next($request);
			} else
				return abort(403);
		} else
			return $next($request);
	}
}
