<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class SetLocale
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $switch  = [];
        $languages = array_keys(languages());
        $segments = $request->segments();
        $locale = isset($segments[0]) ? $segments[0] : '';
        $default = $languages[0] ?? config('app.fallback_locale');
        if (!empty($languages)) {
            if (in_array($locale, $languages)) {
                unset($segments[0]);
            }
            foreach ($languages as $l) {
                $switch[$l] = ($default == $l ? '/' : "/{$l}/") . implode('/', $segments);
            }
            if (!in_array($locale, $languages)) {
                $locale = $languages[0];
            }
        } else {
            $locale = $default;
        }
        app()->setLocale($locale);
        $request->request->add(['lang_switch' => $switch]);

        $request->route()->forgetParameter('locale');

        return $next($request);
    }
}
