<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class Utf8ValidationMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Sanitize all input data for UTF-8 encoding
        $input = $request->all();
        $sanitizedInput = $this->sanitizeArray($input);
        
        // Replace the request input with sanitized data
        $request->replace($sanitizedInput);
        
        return $next($request);
    }
    
    /**
     * Recursively sanitize an array of data for UTF-8 encoding
     */
    private function sanitizeArray($data)
    {
        if (is_array($data)) {
            foreach ($data as $key => $value) {
                $data[$key] = $this->sanitizeArray($value);
            }
        } elseif (is_string($data)) {
            $data = mwz_sanitizeUtf8($data);
        }
        
        return $data;
    }
}
