<?php

namespace App\View\Components\Select2;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;
use Modules\Mwz\app\Http\Controllers\SlugController;

class Multiple extends Component
{
	/**
	 * Create a new component instance.
	 */
	// public $name, $id, $class, $label,  $parent, $url, $placeholder, $required = false,  $selected, $max;
	public function __construct(
		public $url,
		public $id = 'multi',
		public $name = 'multi',
		public $label = '',
		public $parent = '',
		public $class = '',
		public $placeholder = null,
		public $required = null,
		public $selected = null,
		public $max = '',
		public $layer = false,
		public $disabled = false
	) {
		$this->mapping();
	}

	public function mapping()
	{
		$list = [];
		if (!empty($this->selected)) {
			foreach ($this->selected as $item) {
				$attr = [
					'id' => $item->id,
				];
				if (!empty($this->layer)) {
					$attr['text'] = str_implode(' &raquo; ', $this->parent($item));
				} else {
					$attr['text'] = str_implode(' | ', $item->sku ?? null, $item->local->name ?? null, $item->name ?? null);
				}
				if (!empty($item->code)) {
					$attr['code'] = $item->code ?? '';
				}
				if (!empty($item->flag)) {
					$attr['flag'] = $item->flag ?? '';
				}
				if (!empty($item->image)) {
					$attr['image'] = $item->icon ?? $item->image ?? '';
				}
				$list[] = $attr;
			}

			$this->selected = json_encode($list, 1);
		}
	}
	private function parent($query = null, $row = [])
	{
		if (!empty($query)) {
			if (!empty($query->local->name)) {
				array_unshift($row, $query->local->name);
			} elseif (!empty($query->name)) {
				array_unshift($row, $query->name);
			}
			$row = $this->parent($query->parent ?? null, $row);
		}
		return $row;
	}

	/**
	 * Get the view / contents that represent the component.
	 */
	public function render(): View|Closure|string
	{
		return view('components.select2.multiple');
	}
}
