<?php

namespace App\View\Components\Select2;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class Select extends Component
{
	/**
	 * Create a new component instance.
	 */
	
	public function __construct(
		public $url,
		public $main = 'select2-ajax-with-image',
		public $label = '',
		public $id = 'parent',
		public $name = 'parent',
		public $parent = '',
		public $class = '',
		public $placeholder = null,
		public $selected = ['id' => 2, 'text' => "Wandee Dokmaingam1",],
		public $required = false,
		public $clear = true,
		public $layer = false,
		public $map = true,
		public $disabled = false
	) {
		if ($map)
			$this->mapping();
		elseif (!empty($selected))
			$this->selected = json_encode($selected, 1);
	}

	private function mapping()
	{
		$resp = $this->selected ?? null;
		$list = [];
		if (!empty($resp)) {
			$list['id'] = $resp->id ?? 0;
			if (!empty($this->layer)) {
				$list['text'] = str_implode(' &raquo; ', $this->parent($resp));
			} else if (!empty($resp->local->name)) {
				$list['text'] = $resp->local->name ?? '';
			} elseif (!empty($resp->slug)) {
				$list['text'] = $resp->slug ?? '';
			} elseif (!empty($resp->name)) {
				$list['text'] = $resp->name ?? '';
			} elseif (!empty($resp->type)) {
				$list['text'] = __('field.' . strtolower($resp->type ?? ''));
			} else {
				$list['text'] = null;
			}

			if (!empty($resp->image))
				$list['image'] = $resp->icon ?? $resp->image ?? '';

			if (!empty($resp->code)) {
				$list['code'] = $resp->code ?? '';
			}
			if (!empty($resp->flag)) {
				$list['flag'] = $resp->flag ?? '';
			}
			if (!empty($list))
				$this->selected = json_encode($list, 1);
		}
	}
	private function parent($query = null, $row = [])
	{
		if (!empty($query)) {
			if (!empty($query->local->name)) {
				array_unshift($row, $query->local->name);
			} elseif (!empty($query->name)) {
				array_unshift($row, $query->name);
			}
			$row = $this->parent($query->parent ?? null, $row);
		}
		return $row;
	}
	/**
	 * Get the view / contents that represent the component.
	 */
	public function render(): View|Closure|string
	{
		return view('components.select2.select');
	}
}
