<?php

namespace App\View\Components\Select2;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class Selection extends Component
{
	/**
	 * Create a new component instance.
	 */
	public function __construct(
		public $label = '',
		public $name = '',
		public $id = '',
		public $class = '',
		public $placeholder = null,
		public $required = false,
		public $clear = false,
		public $disabled = false
	) {}

	/**
	 * Get the view / contents that represent the component.
	 */
	public function render(): View|Closure|string
	{
		return view('components.select2.selection');
	}
}
