<?php

namespace App\View\Components\Upload;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class Multiple extends Component
{
	public function __construct(
		public $id = 'image',
		public $name = 'image',
		public $files = null,
		public $action =  '',
		public $thumbnail =  '',
		public $max =  5,
		public $accept = null,
		public $upload_msg =  'Drop image here (or click) to capture/upload',
		public $remove_msg = 'remove',
		public $max_msg = 'You can not upload any more files.',
		public $recommend = null,
		// public $inputs = ['name_th' => 'ชื่อสินค้า (TH)', 'name_en' => 'ชื่อสินค้า (EN)']
		public $inputs = []
	) {
		if (!empty($this->files)) {
			$this->files = json_decode($this->files);
		}
		if (empty($this->accept)) {
			$this->accept = implode(',', mime_type('image'));
		}
	}

	/**
	 * Get the view / contents that represent the component.
	 */
	public function render(): View|Closure|string
	{
		return view('components.upload.multiple');
	}
}
