<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Upload Configuration
    |--------------------------------------------------------------------------
    |
    | This file contains configuration options for file uploads including
    | maximum file sizes, allowed file types, and validation rules.
    |
    */

    'max_file_size' => env('UPLOAD_MAX_FILE_SIZE', '2M'),
    
    'max_post_size' => env('POST_MAX_SIZE', '2M'),
    
    'max_upload_files' => env('MAX_UPLOAD_FILES', 10),
    
    'allowed_image_types' => [
        'image/jpeg',
        'image/jpg', 
        'image/png',
        'image/gif',
        'image/bmp',
        'image/webp',
        'image/svg+xml',
        'image/x-icon',
        'image/vnd.microsoft.icon',
    ],
    
    'allowed_document_types' => [
        'application/pdf',
        'application/msword',
        'application/vnd.ms-excel',
        'application/vnd.ms-powerpoint',
        'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
        'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
        'application/vnd.openxmlformats-officedocument.presentationml.presentation',
        'text/plain',
        'text/csv',
    ],
    
    'allowed_audio_types' => [
        'audio/mpeg',
        'audio/mp4',
        'audio/aac',
        'audio/wav',
        'audio/ogg',
    ],
    
    'allowed_video_types' => [
        'video/mp4',
        'video/avi',
        'video/mov',
        'video/wmv',
        'video/webm',
        'video/quicktime',
    ],
    
    'favicon_sizes' => [
        'width' => 100,
        'height' => 100,
    ],
    
    'image_quality' => 85,
    
    'storage_disk' => env('UPLOAD_STORAGE_DISK', 'public'),
    
    'temp_directory' => env('UPLOAD_TEMP_DIR', 'temp'),
    
    'cleanup_temp_files' => env('UPLOAD_CLEANUP_TEMP', true),
    
    'temp_file_lifetime' => env('UPLOAD_TEMP_LIFETIME', 24), // hours
];
