// Equal Height Cards for Service Section
document.addEventListener('DOMContentLoaded', function() {
    const serviceSlide = document.querySelector('.service-slide');
    if (serviceSlide) {
        // รอให้ Owl Carousel โหลดเสร็จ
        setTimeout(function() {
            equalizeCardHeights();
        }, 1000);
        
        // เรียกใช้ทุกครั้งที่ carousel เปลี่ยน
        if (typeof $ !== 'undefined' && $.fn.owlCarousel) {
            serviceSlide.addEventListener('changed.owl.carousel', equalizeCardHeights);
        }
        
        // เรียกใช้เมื่อหน้าจอเปลี่ยนขนาด
        window.addEventListener('resize', function() {
            setTimeout(equalizeCardHeights, 300);
        });
    }
});

function equalizeCardHeights() {
    const cards = document.querySelectorAll('.service-slide .article-card');
    if (cards.length === 0) return;
    
    let maxHeight = 0;
    
    // รีเซ็ตความสูงก่อน
    cards.forEach(card => {
        card.style.height = 'auto';
    });
    
    // หาความสูงสูงสุด
    cards.forEach(card => {
        const height = card.offsetHeight;
        if (height > maxHeight) maxHeight = height;
    });
    
    // กำหนดความสูงให้เท่ากัน
    cards.forEach(card => {
        card.style.height = maxHeight + 'px';
    });
    
    console.log('Cards equalized to height:', maxHeight + 'px');
}
