document.addEventListener('scroll', function () {
	const button = document.getElementById('btnBackToTop');

	button.classList.toggle('opacity-100', window.scrollY > 200);
	button.classList.toggle('pointer-events-auto', window.scrollY > 200);
	button.classList.toggle('opacity-0', window.scrollY <= 200);
	button.classList.toggle('pointer-events-none', window.scrollY <= 200);
});

window.toggleMobileMenu = () => {
	const menu = document.getElementById("mobile-menu");
	const menuIcon = document.querySelector('.menu-icon')
	const closeIcon = document.querySelector('.close-icon')

	menu.classList.toggle("max-h-0")
	menu.classList.toggle("max-h-[500px]")
	menuIcon.classList.toggle('hidden')
	closeIcon.classList.toggle('hidden')
}

window.scrollToTop = () => {
	window.scrollTo({
		top: 0,
		behavior: 'smooth'
	});
}

window.set_accept_policy = (status) => {
	$.ajax({
		url: '/api/v1/pdpa/save',
		type: "POST",
		data: {
			status: status,
			lang: $_lang
		},
		headers: {
			'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		},
		success: (resp) => {
			$('.cookies-wrapper').fadeOut('slow');
		},
		error: (resp) => {
		}
	});
}