@if (!empty($label))
    <label class="form-label {{ $required ? 'required' : '' }}">{{ $label ?? '' }}</label>
@endif
<div class="input-group">
    @if (!empty($icon))
        <span class="input-group-text bg-transparent"><i class="{{ $icon }}"></i></span>
    @elseif($type == 'mail')
        <span class="input-group-text bg-transparent"><i class="fe-mail"></i></span>
    @elseif($type == 'tel')
        <span class="input-group-text bg-transparent"><i class="fe-phone-call"></i></span>
    @elseif($type == 'date')
        <span class="input-group-text bg-transparent"><i class="fe-calendar"></i></span>
    @endif
    @switch($type)
        @case('text')
            <textarea class="form-control {{ $class ?? '' }}" id="{{ $id }}" name="{{ $name }}" data-lang="{{ $lang }}" rows="{{ $rows ?? 4 }}" placeholder="{{ $placeholder ?? ($label ?? '') }}" @if (!empty($maxlength)) maxlength="{{ $maxlength }}" @endif @if (!empty($minlength)) minlength="{{ $minlength }}" @endif @if (!empty($readonly)) readonly @endif>{!! mwz_getTextString($value ?? '') !!}</textarea>
        @break

        @case('texteditor')
            <textarea class="form-control texteditor {{ $class ?? '' }}" id="{{ $id }}" name="{{ $name }}" data-lang="{{ $lang }}" placeholder="{{ $placeholder ?? ($label ?? '') }}" @if (!empty($readonly)) readonly @endif @if (!empty($maxlength)) maxlength="{{ $maxlength }}" @endif @if (!empty($minlength)) minlength="{{ $minlength }}" @endif>{!! mwz_getTextString($value ?? '') !!}</textarea>
        @break

        @case('mail')
            <input class="form-control {{ $class ?? '' }}" id="{{ $id }}" name="{{ $name }}" type="email" value="{{ $value ?? '' }}" placeholder="{{ $placeholder ?? ($label ?? '') }}" @if (!empty($readonly)) readonly @endif @if (!empty($maxlength)) maxlength="{{ $maxlength }}" @endif>
        @break

        @case('tel')
            <input class="form-control {{ $class ?? '' }}" id="{{ $id }}" name="{{ $name }}" type="tel" value="{{ $value ?? '' }}" placeholder="{{ $placeholder ?? ($label ?? '') }}" onkeypress="InputValidateString();" pattern="[0-9]{3} [0-9]{3} [0-9]{4}" @if (!empty($readonly)) readonly @endif @if (!empty($maxlength)) maxlength="{{ $maxlength }}" @endif @if (!empty($minlength)) minlength="{{ $minlength }}" @endif>
        @break

        @case('number')
            <input class="form-control {{ $class ?? '' }}" id="{{ $id }}" name="{{ $name }}" type="text" value="{{ $value ?? '' }}" placeholder="{{ $placeholder ?? ($label ?? '') }}" onkeypress="InputValidateString();" @if (!empty($readonly)) readonly @endif @if (!empty($maxlength)) maxlength="{{ $maxlength }}" @endif @if (!empty($minlength)) minlength="{{ $minlength }}" @endif>
        @break

        @case('color')
            <input class="form-control {{ $class ?? '' }}" id="{{ $id }}" name="{{ $name }}" type="color" value="{{ $value ?? '' }}" placeholder="{{ $placeholder ?? ($label ?? '') }}" @if (!empty($readonly)) readonly @endif>
        @break

        @case('date')
            <input class="form-control {{ !empty($class) ? $class : (empty($readonly) ? 'date-picker' : '') }}" id="{{ $id }}" name="{{ $name }}" type="text" value="{{ $value ?? '' }}" @if (!empty($readonly)) readonly @endif placeholder="{{ $placeholder ?? ($label ?? '') }}">
        @break
        @case('pass')
            <input class="form-control {{ $class ?? '' }}" id="{{ $id }}" name="{{ $name }}" type="password" value="{{ $value ?? '' }}" placeholder="{{ $placeholder ?? ($label ?? '') }}" @if (!empty($readonly)) readonly @endif @if (!empty($maxlength)) maxlength="{{ $maxlength }}" @endif @if (!empty($minlength)) minlength="{{ $minlength }}" @endif>
        @break

        @default
            <input class="form-control {{ $class ?? '' }}" id="{{ $id }}" name="{{ $name }}" data-lang="{{ $lang }}" type="text" value="{{ mwz_getTextString($value ?? '') }}" placeholder="{{ $placeholder ?? ($label ?? '') }}" @if (!empty($readonly)) readonly @endif @if (!empty($maxlength)) maxlength="{{ $maxlength }}" @endif @if (!empty($minlength)) minlength="{{ $minlength }}" @endif>
        @break
    @endswitch
    @if (!empty($end))
        <span class="input-group-text bg-transparent">{!! $end ?? '' !!}</span>
    @endif
</div>
