<div class="navbar-custom">
    <ul class="list-unstyled topnav-menu float-end mb-0">
        <li class="dropdown notification-list d-none d-sm-block">
            <a class="nav-link waves-effect waves-light" href="/" target="_blank">
                <i class="mdi mdi-monitor noti-icon"></i>
            </a>
        </li>
        <li class="dropdown topbar-dropdown">
            <a class="nav-link dropdown-toggle nav-user me-0 waves-effect waves-light" data-bs-toggle="dropdown" href="#" role="button" aria-haspopup="false" aria-expanded="false">
                @if (!empty($user->avatar) && CheckFileInServer($user->avatar))
                    <img class="avatar-sm rounded-circle" src="{{ $user->avatar ?? '#' }}">
                @else
                    <div class="avatar-sm"> <span class="avatar-title bg-primary font-20 rounded-circle text-uppercase">
                            {{ limit($user->name ?? '', 1, '') }} </span></div>
                @endif
                <span class="pro-user-name ms-1"> {{ $user->name ?? '' }} <i class="mdi mdi-chevron-down"></i></span>
            </a>

            <div class="dropdown-menu dropdown-menu-end profile-dropdown ">
                <a class="dropdown-item d-sm-none" href="/" target="_blank">
                    <i class="mdi mdi-monitor noti-icon"></i>
                    <span>Website</span>
                </a>
                <div class="dropdown-divider d-sm-none"></div>

                {{-- @if (mwz_roles('admin.user.user.edit')) --}}
                <a class="dropdown-item" href="{{ route('admin.user.user.edit', $user->id ?? 0) }}">
                    <i class="fe-user"></i> <span>My Account</span>
                </a>
                {{-- @else
                    <a class="dropdown-item" href="{{ route('admin.homepage') }}">
                        <i class="fe-user"></i> <span>My Account</span>
                    </a>
                @endif --}}
                <div class="dropdown-divider"></div>
                <!-- item-->
                <a class="dropdown-item" href="{{ route('admin.logout') }}">
                    <i class="fe-log-out"></i> <span>Logout</span>
                </a>
            </div>
        </li>
    </ul>

    <!-- LOGO -->
    <div class="logo-box">
        <div class="logo text-center full-url">
            <span class="logo-lg">
                <img src="{{ check_file($set->logo_header ?? '', asset('assets/images/logo-alt.png')) }}">
            </span>
            <span class="logo-sm px-1">
                <img src="{{ check_file($set->logo_header ?? '', asset('assets/images/logo-alt.png')) }}">
            </span>
            <a href="{{ route('admin.homepage') }}"></a>
        </div>
    </div>
    <ul class="list-unstyled topnav-menu topnav-menu-left mb-0">
        <li> <button class="button-menu-mobile disable-btn waves-effect"><i class="fe-menu"></i> </button></li>
        @if (!empty($navbar))
            <li>
                <ol class="page-title-main breadcrumb">
                    <li class="breadcrumb-item full-url">
                        <i class="mdi mdi-home"></i>
                        <a href="{{ route('admin.homepage') }}"></a>
                    </li>
                    {{-- <li class="breadcrumb-item full-url">
                        {{ __('admin.homepage') }} <a href="{{ route('admin.homepage') }}"></a>
                    </li> --}}
                    @foreach ($navbar as $k => $item)
                        <li class="breadcrumb-item {{ $loop->last == $loop->iteration ? 'active' : 'full-url' }}">
                            {{ $item['name'] ?? '' }}
                            @if (!empty($item['url']))
                                <a href="{{ $item['url'] ?? '#' }}"></a>
                            @endif
                        </li>
                    @endforeach
                </ol>
            </li>
        @endif
    </ul>
    <div class="clearfix"></div>
</div>
