<div>
    <label class="form-label"> {{ $label ?? __('upload.title') }}</label>
    <label class="label-upload i" for="upload_image{{ $id }}">
        <div class="image-upload mwz-image-upload upload_image{{ $id }}" data-id="{{ $id }}" data-size="{{ $size ?? '' }}">
            <button class="btn btn-upload btn-delete" id="btn_delete{{ $id }}" data-cancel-txt="{{ __('upload.cancel_txt') }}" data-confirm-del-txt="{{ __('upload.confirm_del_txt') }}" data-confirm-txt="{{ __('upload.confirm_txt') }}" data-upload-click-to-upload-txt="{{ __('upload.txt') }}" type="button" {{ empty($image) || !empty($hiddenBtnDel) ? 'style=display:none;' : '' }}><i class="fe-trash-2"></i></button>
            <div class="dz-message upload_show_img_container">
                <div class="d-upload-image" id="upload_show_img_{{ $id }}">
                    @if (!empty($image))
                        <p>
                            @switch($type)
                                @case('favicon')
                                @case('image')
                                    <img class="img-responsive" src="{{ $image }}">
                                @break

                                @case('audio')
                                    <i class="fe-play-circle fs-4"></i>
                                @break

                                @case('video')
                                    <iframe src="{{ $image }}?autohide=0&showinfo=0&controls=0"></iframe>
                                @break

                                @default
                                    <i class="fe-file-text fs-4"></i>
                            @endswitch
                        </p>
                    @else
                        <i class="mdi mdi-cloud-upload-outline"></i>
                        <p><b>{{ __('upload.txt') }}</b></p>
                    @endif
                </div>
            </div>
            <div class="input-upload">
                <input id="upload_image{{ $id }}" name="{{ $name }}" type="file" accept="{{ $accept }}" @if (!empty($hiddenBtnDel)) disabled @endif />
                <input id="upload_image{{ $id }}_del" name="{{ $name }}_del" type="hidden" value="0" @if (!empty($hiddenBtnDel)) disabled @endif />
                <input id="upload_image{{ $id }}_old" name="{{ $name }}_old" type="hidden" value="{{ $image ?? '' }}" @if (!empty($hiddenBtnDel)) disabled @endif />
            </div>
        </div>
    </label>
    <span class="upload-recommend">{{ __('upload.recommend') }}&nbsp;{{ $recommend ?? '' }}</span>
</div>
