<?php use Modules\Frontend\app\Http\Controllers\FrontendInitController; ?>
<div>
    <!-- แสดงข้อมูล -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title mb-4">
                        <i class="fas fa-user-circle me-2"></i>รายละเอียดพนักงาน
                    </h5>
                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="">
                                <label class="form-label text-muted fw-bold">
                                    <i class="fas fa-id-card me-2"></i>รหัสพนักงาน
                                </label>
                                <p class="form-control-plaintext border-bottom pb-2"><?php echo e($data->member->code ?? '-'); ?>

                                </p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="">
                                <label class="form-label text-muted fw-bold">
                                    <i class="fas fa-user me-2"></i>ชื่อ
                                </label>
                                <p class="form-control-plaintext border-bottom pb-2"><?php echo e($data->member->name ?? '-'); ?>

                                </p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="">
                                <label class="form-label text-muted fw-bold">
                                    <i class="fas fa-envelope me-2"></i>อีเมล
                                </label>
                                <p class="form-control-plaintext border-bottom pb-2"><?php echo e($data->member->email ?? '-'); ?>

                                </p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="">
                                <label class="form-label text-muted fw-bold">
                                    <i class="fas fa-briefcase me-2"></i>ตำแหน่ง
                                </label>
                                <p class="form-control-plaintext border-bottom pb-2">
                                    <?php echo e($data->member->position ?? '-'); ?></p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="">
                                <label class="form-label text-muted fw-bold">
                                    <i class="fas fa-briefcase me-2"></i>ฝ่าย
                                </label>
                                <p class="form-control-plaintext border-bottom pb-2">
                                    <?php echo e($data->member->department ?? '-'); ?></p>
                            </div>
                        </div>
                        
                        <div class="col-12">
                            <table class="table table-bordered mb-0">
                                <tbody>
                                    <tr>
                                        <th class="text-muted fw-bold" style="width: 30%;">
                                        สถานที่ปัจจุบัน
                                        </th>
                                        <td><?php echo e($data->current_place ?? '-'); ?></td>
                                    </tr>
                                    <tr>
                                        <th class="text-muted fw-bold">
                                        สถานที่จะไป
                                        </th>
                                        <td><?php echo e($data->target_place ?? '-'); ?></td>
                                    </tr>
                                    <tr>
                                        <th class="text-muted fw-bold">
                                        ระยะทาง (กม.)
                                        </th>
                                        <td><?php echo e($data->distance_km ?? '-'); ?></td>
                                    </tr>
                                    <tr>
                                        <th class="text-muted fw-bold">
                                        ค่าน้ำมัน (บาท)
                                        </th>
                                        <td><?php echo e($data->oil_price ?? '-'); ?></td>
                                    </tr>
                                    <tr>
                                        <th class="text-muted fw-bold">
                                        วันที่
                                        </th>
                                        <td><?php echo e($data->created_at ? $data->created_at->format('d/m/Y') : '-'); ?></td>
                                    </tr>
                                    <tr>
                                        <th class="text-muted fw-bold">
                                        เวลาเช็คอิน
                                        </th>
                                        <td><?php echo e($data->time ? $data->time->format('H:i') : '-'); ?></td>
                                    </tr>
                                    <tr>
                                        <th class="text-muted fw-bold">
                                        เวลาเช็คเอาท์
                                        </th>
                                        <td><?php echo e($data->checkout_time ? $data->checkout_time->format('H:i') : '-'); ?></td>
                                    </tr>
                                    <tr>
                                        <th class="text-muted fw-bold">
                                        สถานะ
                                        </th>
                                        <td>
                                            <?php echo $data->status ? FrontendInitController::status_appove($data->status) : '-'; ?>

                                            <?php echo $data->remarks ? '<br><small class="text-muted">' . $data->remarks . '</small>' : ''; ?>

                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /newdata/uatnewndco/public_html/nacal-hr.mwz/Modules/Member/resources/views/timeline/detail.blade.php ENDPATH**/ ?>