<!DOCTYPE html>
<html lang="th">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>รายงาน Timeline การเดินทาง</title>
    <style>
        @page {
            margin: 120px 30px 130px;
        }

        @font-face {
            font-family: 'NotoSansThai';
            font-style: normal;
            font-weight: normal;
            src: url('<?php echo e(storage_path('fonts/NotoSansThai-Regular.ttf')); ?>') format('truetype');
        }

        @font-face {
            font-family: 'NotoSansThai';
            font-style: normal;
            font-weight: bold;
            src: url('<?php echo e(storage_path('fonts/NotoSansThai-Bold.ttf')); ?>') format('truetype');
        }

        body {
            font-family: 'NotoSansThai', sans-serif;
            font-size: 12pt;
            margin: 0;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 0;
            page-break-inside: auto;
            border: 1px solid #000;
        }

        th,
        td {
            border: 1px solid #000;
            padding: 6px;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
            font-weight: bold;
            font-size: 13pt;
        }

        tr {
            page-break-inside: avoid;
            page-break-after: auto;
        }

        thead tr th:last-child,
        tbody tr td:last-child,
        tfoot tr th:last-child {
            border-right: 1px solid #000;
        }

        .text-center {
            text-align: center;
        }

        .text-right {
            text-align: right;
        }

        .info {
            margin-bottom: 20px;
        }

        .summary {
            margin-top: 0;
            padding: 15px;
            background-color: #f9f9f9;
            border: 1px solid #000;
        }

        .summary-row {
            display: inline-block;
            width: 48%;
            margin-bottom: 10px;
        }

        .mb-1 {
            margin-bottom: 4px;
        }

        .page-header {
            position: fixed;
            top: -105px;
            left: 0;
            right: 0;
            text-align: center;
        }

        .page-header h1 {
            font-size: 18pt;
            font-weight: bold;
            margin-bottom: 10px;
        }

        .page-footer {
            position: fixed;
            bottom: -120px;
            left: 0;
            right: 0;
            page-break-after: avoid;
        }

        main {
            padding-top: 10px;
        }

        thead {
            display: table-header-group;
        }

        tfoot {
            display: table-row-group;
        }
    </style>
</head>

<body>
    <?php
        $totalDistance = collect($timelines)->sum(fn ($timeline) => $timeline->distance_km ?? 0);
        $totalOil = collect($timelines)->sum(fn ($timeline) => $timeline->oil_price ?? 0);
    ?>

    <div class="page-header">
        <h1 style="margin-bottom: -5px;">รายงาน Timeline การเดินทาง</h1>
        <div class="info" style="display: flex; justify-content: center; gap: 20px;">
            <div class="mb-1" style="margin-bottom: -5px;"><strong>วันที่ออกรายงาน:</strong> <?php echo e(date('d/m/Y H:i:s')); ?></div>
            <div class="mb-1"><strong>จำนวนรายการทั้งหมด:</strong> <?php echo e(count($timelines)); ?> รายการ</div>
        </div>
    </div>

    <div class="page-footer">
        <div class="summary">
            <strong style="font-size: 16pt;">สรุปข้อมูล</strong><br><br>
            <div class="summary-row">
                <strong>ระยะทางรวม:</strong> <?php echo e(number_format($totalDistance, 2)); ?> กิโลเมตร
            </div>
            <div class="summary-row" style="float: right;">
                <strong>ค่าน้ำมันรวม:</strong> <?php echo e(number_format($totalOil, 2)); ?> บาท
            </div>
        </div>
    </div>

    <main>
        <table>
            <thead>
                <tr>
                    <th class="text-center" width="5%">ลำดับ</th>
                    <th width="13%">สมาชิก</th>
                    <th width="12%">สถานที่ปัจจุบัน </th>
                    <th width="12%">สถานที่จะไป</th>
                    <th class="text-center" width="8%">ระยะทาง (กม.)</th>
                    <th class="text-center" width="10%">ค่าน้ำมัน</th>
                    <th class="text-center" width="8%">วันที่</th>
                    <th class="text-center" width="8%">เช็คอิน</th>
                    <th class="text-center" width="8%">เช็คเอาท์</th>
                    <th class="text-center" width="10%">สถานะ</th>
                </tr>
            </thead>
            <tbody>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $timelines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $timeline): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <?php
                        $statusText = match ((int) ($timeline->status ?? 0)) {
                            1 => 'รอส่งคำขอ',
                            2 => 'รออนุมัติ',
                            3 => 'รออนุมัติ',
                            4 => 'อนุมัติ',
                            13 => 'ไม่อนุมัติ',
                            default => '-',
                        };
                    ?>
                    <tr>
                        <td class="text-center"><?php echo e($index + 1); ?></td>
                        <td><?php echo e($timeline->member->name ?? '-'); ?></td>
                        <td><?php echo e($timeline->current_place ?? ($timeline->place ?? '-')); ?></td>
                        <td><?php echo e($timeline->target_place ?? ($timeline->checkout_address ?? '-')); ?></td>
                        <td class="text-center">
                            <?php echo e($timeline->distance_km ? number_format($timeline->distance_km, 2) : '-'); ?>

                        </td>
                        <td class="text-right">
                            <?php echo e($timeline->oil_price ? number_format($timeline->oil_price, 2) : '-'); ?>

                        </td>
                        <td class="text-center">
                            <?php echo e($timeline->created_at ? $timeline->created_at->format('d/m/Y') : '-'); ?>

                        </td>
                        <td class="text-center">
                            <?php echo e($timeline->time ? \Carbon\Carbon::parse($timeline->time)->format('H:i') : '-'); ?>

                        </td>
                        <td class="text-center">
                            <?php echo e($timeline->checkout_time ? \Carbon\Carbon::parse($timeline->checkout_time)->format('H:i') : '-'); ?>

                        </td>
                        <td class="text-center" width="10%"><?php echo e($statusText); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="11" class="text-center">ไม่พบข้อมูล</td>
                    </tr>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </tbody>
            <tfoot>
                <tr>
                    <th colspan="6" class="text-right">รวมทั้งหมด:</th>
                    <th class="text-center"><?php echo e(number_format($totalDistance, 2)); ?></th>
                    <th class="text-right"><?php echo e(number_format($totalOil, 2)); ?></th>
                    <th colspan="2"></th>
                </tr>
            </tfoot>
        </table>
    </main>
</body>

</html>
<?php /**PATH /newdata/uatnewndco/public_html/nacal-hr.mwz/Modules/Member/resources/views/exports/check-in-out-pdf.blade.php ENDPATH**/ ?>