<?php $__env->startSection('styles'); ?>
    <?php echo e(module_vite('build-user', 'resources/assets/sass/app.scss')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php $setting = setting(); ?>
    <div class="row justify-content-center">
        <div class="col-md-8 col-lg-6 col-xl-4">
            <div class="login-logo">
                <img src="<?php echo e(check_file($setting->logo_header ?? '', asset('assets/images/logo-alt.png'))); ?>">
            </div>
            <div class="card card-body shadow-none">
                <div class="text-center">
                    <h4 class="text-uppercase my-2"><?php echo e(__('user::login.title')); ?></h4>
                </div>
                <form id="login_frm" onsubmit="set_login(); return false;">
                    <?php echo csrf_field(); ?>
                    <div class="mb-2">
                        <label class="form-label" for="username"><?php echo e(__('user::login.frm.username')); ?></label>
                        <input class="form-control" id="username" name="username" type="text" autocomplete="new-username" placeholder="<?php echo e(__('user::login.frm.username_placeholder')); ?>">
                    </div>
                    <div class="mb-2">
                        <label class="form-label" for="password"><?php echo e(__('user::login.frm.password')); ?></label>
                        <div class="input-group input-group-merge">
                            <input class="form-control" id="password" name="password" type="password" placeholder="<?php echo e(__('user::login.frm.password_placeholder')); ?>" autocomplete="new-password">
                            <div class="input-group-text" data-password="false"> <span class="password-eye"></span></div>
                        </div>
                    </div>
                    <div class="mb-3 form-check">
                        <input class="form-check-input" id="remember" name="remember" type="checkbox" value="1">
                        <label class="form-check-label" for="remember"><?php echo e(__('user::login.frm.remember')); ?></label>
                    </div>
                    <div class="d-grid text-center">
                        <button class="btn btn-primary" type="submit"><?php echo e(__('user::login.frm.submit')); ?></button>
                    </div>
                </form>
            </div>
            <div class="d-grid text-center">
                <?php echo e($setting->local->copy_right ?? ''); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <!-- if production -->
    <?php echo e(module_vite('build-user', 'resources/assets/js/login.js')); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('login.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /newdata/uatnewndco/public_html/nacal-hr.mwz/Modules/User/resources/views/login/form.blade.php ENDPATH**/ ?>