<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>รีเซ็ตรหัสผ่าน</title>
    <style>
        body {
            font-family: 'Sarabun', Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .email-container {
            max-width: 600px;
            margin: 20px auto;
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            overflow: hidden;
        }
        .email-header {
            background-color: #4F46E5;
            color: #ffffff;
            padding: 30px;
            text-align: center;
        }
        .email-header h1 {
            margin: 0;
            font-size: 24px;
        }
        .email-body {
            padding: 30px;
            color: #333333;
        }
        .email-body p {
            line-height: 1.6;
            margin-bottom: 20px;
        }
        .reset-button {
            display: inline-block;
            padding: 12px 30px;
            background-color: #4F46E5;
            color: #ffffff;
            text-decoration: none;
            border-radius: 5px;
            margin: 20px 0;
            font-weight: bold;
        }
        .reset-button:hover {
            background-color: #4338CA;
        }
        .email-footer {
            background-color: #f9fafb;
            padding: 20px;
            text-align: center;
            color: #666666;
            font-size: 14px;
        }
        .divider {
            border-top: 1px solid #e5e7eb;
            margin: 20px 0;
        }
    </style>
</head>
<body>
    <div class="email-container">
        <div class="email-header">
            <h1><?php echo e($title); ?></h1>
        </div>
        <div class="email-body">
            <p>สวัสดี,</p>
            
            <p>คุณได้รับอีเมลนี้เนื่องจากเราได้รับคำขอรีเซ็ตรหัสผ่านสำหรับบัญชีของคุณ</p>
            
            <div style="text-align: center;">
                <a href="<?php echo e($link); ?>" style="color: #ffffff;" class="reset-button text-white">รีเซ็ตรหัสผ่าน</a>
            </div>
            
            <p>ลิงก์รีเซ็ตรหัสผ่านนี้จะหมดอายุใน 60 นาที</p>
            
            <div class="divider"></div>
            
            <p style="font-size: 14px; color: #666666;">
                หากคุณไม่ได้ขอรีเซ็ตรหัสผ่าน ไม่จำเป็นต้องดำเนินการใดๆ
            </p>
            
        </div>
        <div class="email-footer">
            <p><?php echo $copy_right; ?></p>
        </div>
    </div>
</body>
</html>

<?php /**PATH /newdata/uatnewndco/public_html/nacal-hr.mwz/Modules/Frontend/resources/views/emails/reset-password.blade.php ENDPATH**/ ?>