import { test, expect } from '@playwright/test';

test.describe('Backend Setting Tests', () => {
  const BASE_URL = process.env.BASE_URL || 'http://127.0.0.1:8000';
  const FILE_PATH = process.env.FILE_PATH || "public/assets/images/favicon.ico";


  async function login(page) {
    await page.goto(`${BASE_URL}/admin`);
    await page.getByRole('textbox', { name: 'Username' }).fill('admin');
    await page.getByRole('textbox', { name: 'Password' }).fill('admin');
    await page.getByRole('button', { name: 'Login' }).click();
  }


  test('Test copyright max 255 characters', async ({ page }) => {
    await login(page);


    await page.getByRole('textbox', { name: 'Please specify Copyright' }).fill('test  we9tbewtb ew98btewt7eeertreterterttttttteeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeettuuuuuuuussssssssssssssssssssssssssssssssssssuuuaaaaaaaaaaaaaaaaaaauuuuuuuuuuuuuuuuuuuttttttttttttttttttttttttffffffffffffffffttttt888888888888888888ddddddddddddddddiiiiiiiiiiiiiiiii');
    await page.getByRole('button', { name: ' Save' }).click();

    // Wait for error messages to appear
    await page.waitForSelector('#copy_right_en-error');
    await page.waitForSelector('#toast-container');

    await expect(page.locator('#copy_right_en-error')).toContainText('Please enter no more than 255 characters');
    await expect(page.locator('#toast-container')).toContainText('Please fill in all required fields');


    await page.getByRole('combobox', { name: 'English' }).click();
    await page.getByRole('option', { name: 'ภาษาไทย' }).click();
    await page.getByRole('textbox', { name: 'Please specify Copyright' }).fill('test  we9tbewtb ew98btewt7eeertreterterttttttteeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeettuuuuuuuussssssssssssssssssssssssssssssssssssuuuaaaaaaaaaaaaaaaaaaauuuuuuuuuuuuuuuuuuuttttttttttttttttttttttttffffffffffffffffttttt888888888888888888ddddddddddddddddiiiiiiiiiiiiiiiii');
    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#copy_right_en-error')).toContainText('Please enter no more than 255 characters');
    await expect(page.locator('#toast-container')).toContainText('Please fill in all required fields');

    await page.pause();
  });

  test('Test Header image change upload functionality', async ({ page }) => {
    await login(page);
    // Test adding new image
    const fileInput = page.locator('#upload_image2');
    await fileInput.waitFor({ state: 'attached' });
    await fileInput.setInputFiles('public/assets/images/logo-dark.png');
    await expect(page.locator('#header')).toContainText('Upload image (Header)');
    await expect(page.locator('#submit')).toContainText('Save');
    await page.getByText("Save").click();

    await page.pause();
  });

  test('Test Header image delete functionality', async ({ page }) => {
    await login(page);
    // Locate and click the delete photo button
    await page.getByRole('button', { name: '' }).click();
    await expect(page.locator('#swal2-title')).toContainText('Delete');
    await page.getByText('Confirm image deletion ?').click();
    await expect(page.locator('#swal2-content')).toContainText('Confirm image deletion ?');
    await expect(page.getByLabel('Delete')).toContainText('Cancel');
    await expect(page.getByLabel('Delete')).toContainText('Confirm');
    await page.getByRole('button', { name: 'Confirm' }).click();
    await page.getByRole('button', { name: ' Save' }).click();
    const headerLogo = page.locator('#header img');
    await expect(headerLogo).not.toBeVisible();
    await page.pause();
  });

  test('Test header image upload functionality', async ({ page }) => {
    await login(page);

    // Test adding new image
    const fileInput = page.locator('#upload_image1');
    await fileInput.waitFor({ state: 'attached' });
    await fileInput.setInputFiles('public/assets/images/logo-dark-2.png');
    await expect(page.locator('#header')).toContainText('Upload image (Header)');
    await expect(page.locator('#submit')).toContainText('Save');
    await page.getByText("Save").click();

    await page.pause();
  });

  //test invalid file type upload for header image
  test('Test invalid file type upload for header image', async ({ page }) => {
    await login(page);
    const fileInput = page.locator('#upload_image1');
    await fileInput.waitFor({ state: 'attached' });

    // Try uploading invalid file
    await fileInput.setInputFiles('tests/AGENTS.md');

    // Check the label instead of the input
    await expect(page.getByText('Upload image (Header)')).toBeVisible();

    await expect(page.locator('#submit')).toContainText('Save');
    await page.getByText("Save").click();

    // Assert error message is shown
    await expect(
      page.getByText('Logo header File type cannot be uploaded', { exact: false })
    ).toBeVisible({ timeout: 5000 });

    await page.pause();

  });

  test('Test file size limit for header image', async ({ page }) => {
    await login(page);
    const fileInput = page.locator('#upload_image1');
    await fileInput.waitFor({ state: 'attached' });
    await fileInput.setInputFiles('public/modules/frontend/img/ser1.jpg'); // 6MB file
    await expect(
      page.getByText('File size is too large', { exact: false })
    ).toBeVisible({ timeout: 5000 })
    await page.getByRole('button', { name: 'Save' }).click();

    // Assert error message is shown
    await expect(
      page.getByText('File size exceeds the limit', { exact: false })
    ).toBeVisible({ timeout: 5000 });

    await page.pause();
  });
});